SET SQL_SAFE_UPDATES = 0;

SET @applicantSendOffer=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');

	UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
   T2.id AS ID,
   T3.`salutationName` AS SALUTATION_NAME,
   T2.`firstName` AS FIRST_NAME,
   T2.`middleName` AS MIDDLE_NAME,
   T2.`lastName` AS LAST_NAME,
   T2.`emailId` AS EMAIL_ID,
   T2.`mobileNumber` AS MOBILE_NO,
   T2.`mobileCountryCode` AS MOBILE_CODE,
   T5.`loginId` AS LOGIN_ID,
   CONVERT(FROM_BASE64(T5.passwordBase64) USING utf8) AS PASSWORD,
   CONCAT(T9.addressText,' ',T10.cityName,', ',T11.countryName,', ',T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
   DATE_FORMAT(T14.admissionOfferStartDate ,'%d-%m-%Y') as OFFER_LETTER_START_DATE,
   DATE_FORMAT(T14.admissionOfferEndDate ,'%d-%m-%Y') as OFFER_LETTER_END_DATE,
   CONCAT(T9.phoneCountryCode,'-',T9.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T9.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T9.websiteURL AS ACADEMY_LOCATION_URL,
   'APPLICANT' AS USER_TYPE_KEY,
   (Case 
        when 
            T15.offerType = 'FIRM'
        then 
            'Firm'
  when 
            T15.offerType = 'PROVISIONAL'
        then 
            'Provisional'
        else '' 
    end) as FIRM_OR_PROVISIONAL,
    (CASE
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
            WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED'
        THEN
            'Escalated'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED_OFFER_REVIEWED'
        THEN
            'Escalated Offer Reviewed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WAITING_LIST'
        THEN
            'Waiting List'  
        ELSE ''
    END) AS OFFER_STATUS,
    DATE_FORMAT(T1.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
    (CASE
        WHEN
            T7.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T7.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T7.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T7.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        else NULL 
    end) as FOOTER_URL,
    T7.id as ACADEMY_LOCATION_ID,
    T7.academyId as ACADEMY_ID
FROM
   `application` T1 
		INNER JOIN
	`applicant_person` T2 ON T2.id = T1.applicantPersonId 
		LEFT JOIN
	`salutations` T3 ON T3.`id` = T2.`salutationId`
		LEFT JOIN
	`external_user_association` T4 ON T4.`applicationId` = T1.`id`
		LEFT JOIN
	`external_users` T5 ON T5.`id` = T4.`externalUserId`
    LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
		LEFT OUTER JOIN
    academy_location T7 ON T7.id = T6.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
		LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId && T9.addressTypeId=10
		LEFT OUTER JOIN
	city T10 ON T10.id = T9.cityId
		LEFT OUTER JOIN
	country T11 ON T11.id = T10.countryId
		LEFT OUTER JOIN
	country_region T12 ON T12.id = T10.countryRegionId
		LEFT JOIN
	program_selection_process T13 on T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
		LEFT JOIN
	prog_slctn_process_admisn_conf T14 on T14.programSelectionProcessId = T13.id
    LEFT JOIN
  app_program_adm_details T15 on T15.applicationProgramId = T6.id and T15.isLatest = true
   LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
   T2.id IN 
   (
      namedParams
   ) group by T2.id ",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "mobile Code",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "Login Id",
            "resultKey": "LOGIN_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "Offer Letter Start Date",
            "resultKey": "OFFER_LETTER_START_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Offer Letter End Date",
            "resultKey": "OFFER_LETTER_END_DATE",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "applicationStatus",
            "resultKey": "APPLICATION_STATUS",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "offerStatus",
            "resultKey": "OFFER_STATUS",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "firmOrProvisional",
            "resultKey": "FIRM_OR_PROVISIONAL",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "applicationDate",
            "resultKey": "APPLICATION_DATE",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 19
        },
        {
            "id": 21,
            "value": "academyLocationEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 20
        },
        {
            "id": 22,
            "value": "academyLocationURL",
            "resultKey": "ACADEMY_LOCATION_URL",
            "displayCode": "",
            "displayOrder": 21
        },
        {
            "id": 23,
            "value": "academyLocationPhoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 22
        },
        {
            "id": 24,
            "value": "academyLocationId",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 23
        },
        {
            "id": 25,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 24
        }
    ]
}' WHERE `dataProviderId`=@applicantSendOffer;

SET SQL_SAFE_UPDATES = 1;